//
// Toroid.js
//  inspired by Grapher
//
//  v.061020
//  required version : Cheetah3D v3.4
//
//  (c) 2006 Hiroto Tsubaki
//  http://www.tres-graficos.jp/
//  tg@tres-graficos.jp
//
// 2006-10-20 fix calculation bug. (thanks Martin.)

var normalType;
var normalAngle;

function buildUI(obj) {
    
    obj.setParameter("name","Troid");
    
    obj.addParameterInt("sections tube",5,3,180,true,true);
    obj.addParameterInt("sections",10,5,360,true,true);
    
    obj.addParameterSeparator("variables");
    obj.addParameterFloat("a",3,-1000,1000,true,true);
    obj.addParameterFloat("b",2,-1000,1000,true,true);
    obj.addParameterFloat("c",2,-1000,1000,true,true);    
    
    obj.addParameterSeparator("Smooth");
    obj.addParameterInt("smooth type", 2,0,2,true,true);
    obj.addParameterFloat("smooth angle", 45.0, 5.0, 90.0, true, true);
    obj.addParameterButton("set smooth","Set","setSmooth");
    
    setSmooth(obj);       
}

function setSmooth(obj) {
    normalType = obj.getParameter("smooth type");
    normalAngle = obj.getParameter("smooth angle");
    
    obj.setParameter("normalType",normalType);
    obj.setParameter("normalAngle",normalAngle);
}

function buildObject(obj) {
    var i,j,k;
    var core = obj.core();
    var step = obj.getParameter("sections tube");
    var section = obj.getParameter("sections");
    var a = obj.getParameter("a");
    var b = obj.getParameter("b");
    var c = obj.getParameter("c");
    
    for (i = 0;i < section;i++) {
        var ang_i = Math.PI*2.0*i/section;
        for (j = 0;j < step;j++) {
            var ang_j = Math.PI*2.0*j/step;
            var vert = new Vec3D(a+Math.sin(ang_i)+Math.cos(ang_j),
                    0,
                    Math.sin(ang_j)+c*Math.cos(ang_i));
            var mat = new Mat4D(ROTATE,0,0,b*ang_i*180/Math.PI);
            vert = mat.multiply(vert);
            core.addVertex(false,vert);
        }
    }
    
    for (i = 0;i < section;i++) {
        k = i * step;
        //print(i);
        for (j = 0;j < step;j++) {
            if (i == section - 1) {
                if (j == step -1) {
                    var poly = [k+j,k+j-step+1,0,k+j-(step*(section-1))];
                } else {
                    var poly = [k+j,k+j+1,k+j+1-(step*(section-1)),k+j-(step*(section-1))];
                }
            } else {
                if (j == step -1) {
                    var poly = [k+j,k+j-step+1,k+j+1,k+j+step];
                } else {
                    var poly = [k+j,k+j+1,k+j+step+1,k+j+step];
                }
            }
            //print(poly);
            var uvs = [
                new Vec2D(1/step*j,1/section*i),
                new Vec2D(1/step*(j+1),1/section*i),
                new Vec2D(1/step*(j+1),1/section*(i+1)),
                new Vec2D(1/step*j,1/section*(i+1))
                ];
            core.addIndexPolygon(4,poly,uvs);
        }
    }
}

